<?php
session_start();
require_once '../config/database.php';

if (isset($_SESSION['user_id'])) {
    header("Location: /servicehp/modules/dashboard/index.php");
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = "Username dan Password wajib diisi!";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['name'] = $user['name'];

            // Log login logic if needed

            header("Location: /servicehp/modules/dashboard/index.php");
            exit();
        } else {
            $error = "Username atau Password salah!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Service HP System</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/servicehp/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, var(--background-color) 0%, var(--primary-light) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .login-card {
            background: var(--surface-color);
            width: 100%;
            max-width: 420px;
            padding: 2.5rem;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-floating);
            border: 1px solid rgba(255,255,255,0.5);
            text-align: center;
        }
        .login-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
            display: inline-block;
            padding: 1rem;
            background: var(--primary-light);
            border-radius: 50%;
        }
        .login-header h2 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            letter-spacing: -0.025em;
        }
        .login-header p {
            color: var(--text-muted);
            margin-bottom: 2rem;
            font-size: 0.95rem;
        }
        .form-group {
            text-align: left;
            margin-bottom: 1.25rem;
        }
        .form-control {
            padding: 0.75rem 1rem;
            background-color: #f8fafc;
        }
        .form-control:focus {
            background-color: var(--surface-color);
        }
        .input-icon-wrapper {
            position: relative;
        }
        .input-icon-wrapper i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-muted);
            opacity: 0.7;
        }
        .input-icon-wrapper .form-control {
            padding-left: 2.75rem;
        }
        .btn-login {
            width: 100%;
            padding: 0.875rem;
            font-size: 1rem;
            font-weight: 600;
            margin-top: 1rem;
            border-radius: var(--radius-lg);
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="login-icon">
            <i class="fas fa-tools"></i>
        </div>
        <div class="login-header">
            <h2>Service HP System</h2>
            <p>Silakan masuk ke akun Anda</p>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger" style="text-align: left; padding: 0.75rem 1rem; font-size: 0.9rem;">
                <i class="fas fa-exclamation-circle me-2"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="username" class="form-label" style="font-weight: 600;">Username</label>
                <div class="input-icon-wrapper">
                    <i class="fas fa-user"></i>
                    <input type="text" id="username" name="username" class="form-control" required autofocus placeholder="Masukkan username">
                </div>
            </div>
            <div class="form-group">
                <label for="password" class="form-label" style="font-weight: 600;">Password</label>
                <div class="input-icon-wrapper">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="password" name="password" class="form-control" required placeholder="Masukkan password">
                </div>
            </div>
            <button type="submit" class="btn-primary btn-login">
                Masuk <i class="fas fa-arrow-right ms-2" style="margin-left: 0.5rem;"></i>
            </button>
        </form>
        
        <div class="mt-4" style="font-size: 0.8rem; color: var(--text-muted);">
            &copy; <?php echo date('Y'); ?> Mahkota Service. All rights reserved.
        </div>
    </div>
</body>
</html>
