-- Disable foreign key checks
SET FOREIGN_KEY_CHECKS = 0;

-- 1. Users (Password: admin123 for all except existing admin)
-- Note: 'admin' user is already created in setup.php
INSERT IGNORE INTO users (username, password, role, name) VALUES 
('teknisi1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'teknisi', 'Budi Teknisi'),
('teknisi2', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'teknisi', 'Andi Teknisi'),
('kasir1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'kasir', 'Siti Kasir');

-- 2. Customers
INSERT IGNORE INTO customers (name, phone, address) VALUES 
('Ahmad Dhani', '081234567890', 'Pondok Indah, Jakarta'),
('Maya Estianty', '081298765432', 'Menteng, Jakarta'),
('Mulan Jameela', '081912345678', 'Bandung'),
('Al Ghazali', '085712340987', 'Jakarta Pusat'),
('El Rumi', '081345678901', 'London, UK'),
('Dul Jaelani', '081233344455', 'Pejaten'),
('Raffi Ahmad', '08170000001', 'Andara'),
('Nagita Slavina', '08170000002', 'Andara');

-- 3. Spareparts (Stock Data)
-- TRUNCATE TABLE spareparts; -- Commented out truncate to be safe, using IGNORE instead
INSERT IGNORE INTO spareparts (name, stock, buy_price, sell_price) VALUES 
('LCD Samsung A51', 10, 350000, 550000),
('LCD Samsung A50', 8, 320000, 500000),
('LCD Samsung A10', 15, 180000, 300000),
('LCD iPhone X (OLED)', 5, 600000, 950000),
('LCD iPhone 11', 7, 400000, 750000),
('Baterai iPhone 11', 12, 150000, 300000),
('Baterai iPhone X', 10, 180000, 350000),
('Baterai Samsung A50', 20, 80000, 150000),
('Baterai Xiaomi RN 9', 25, 75000, 150000),
('Connector Charger Xiaomi Note 9', 30, 10000, 50000),
('Connector Charger Samsung Type-C', 50, 15000, 60000),
('LCD Oppo A5 2020', 8, 200000, 400000),
('LCD Oppo A3s', 12, 150000, 300000),
('Flexible On Off Vivo Y91', 25, 5000, 50000),
('Tempered Glass Universal', 100, 5000, 25000),
('Casing Silicon iPhone 11', 15, 20000, 50000),
('Kabel Data Type-C Robot', 40, 12000, 35000),
('Kepala Charger 2A', 20, 25000, 65000),
('Speaker Xiaomi Redmi 5A', 10, 25000, 75000),
('Kamera Belakang iPhone 7', 3, 250000, 450000);

-- 4. Initial Stock History (Log for creating these items)
INSERT IGNORE INTO stock_history (sparepart_id, type, qty, notes, created_at)
SELECT id, 'in', stock, 'Stok Awal Toko', NOW() FROM spareparts;

-- 5. Service Orders (Dummy Transactions)
INSERT IGNORE INTO service_orders (ticket_number, customer_id, device_name, complaint, physical_condition, status, technician_id, cost_estimation, total_fee, down_payment, created_at, updated_at, payment_method) VALUES 
('SRV-202310-001', 1, 'Samsung A51', 'Layar pecah retak seribu', 'Lecet Pemakaian', 'Pending', NULL, 0, 0, 0, NOW(), NOW(), NULL),
('SRV-202310-002', 2, 'iPhone 11', 'Baterai bocor cepat habis', 'Mulus', 'Checking', 2, 300000, 0, 50000, NOW(), NOW(), NULL),
('SRV-202310-003', 3, 'Xiaomi Redmi Note 9', 'Tidak bisa cas', 'Penyok Dikit di ujung', 'On Process', 2, 75000, 75000, 0, NOW(), NOW(), NULL),
('SRV-202310-004', 4, 'Oppo A5 2020', 'LCD Blank Hitam', 'Goresan Halus', 'Completed', 3, 400000, 400000, 100000, NOW(), NOW(), NULL),
('SRV-202310-005', 5, 'Vivo Y91', 'Tombol power mendlep', 'Tombol Hilang', 'Taken', 3, 50000, 50000, 50000, NOW(), NOW(), 'Cash'),
('SRV-202310-006', 7, 'iPhone X', 'Ghost Touch', 'Backdoor Retak', 'Taken', 2, 950000, 950000, 200000, NOW(), NOW(), 'Transfer');

-- 6. Service History Logs
-- Ticket 001
INSERT IGNORE INTO service_history (service_order_id, status_old, status_new, notes, user_id, created_at) 
SELECT id, 'New', 'Pending', 'Permintaan Masuk', 1, NOW() FROM service_orders WHERE ticket_number = 'SRV-202310-001';

-- Ticket 005 (Taken)
INSERT IGNORE INTO service_history (service_order_id, status_old, status_new, notes, user_id, created_at) 
SELECT id, 'Completed', 'Taken', 'Unit diambil customer', 3, NOW() FROM service_orders WHERE ticket_number = 'SRV-202310-005';

SET FOREIGN_KEY_CHECKS = 1;
