<?php
require_once 'database.php';

try {
    $pdo->beginTransaction();

    echo "Seeding Users...\n";
    $users = [
        ['teknisi1', 'password', 'teknisi', 'Budi Teknisi'],
        ['teknisi2', 'password', 'teknisi', 'Andi Teknisi'],
        ['kasir1', 'password', 'kasir', 'Siti Kasir'],
        ['owner', 'owner', 'admin', 'Pak Bos'],
    ];
    foreach ($users as $u) {
        $stmt = $pdo->prepare("INSERT IGNORE INTO users (username, password, role, name) VALUES (?, ?, ?, ?)");
        $stmt->execute([$u[0], password_hash($u[1], PASSWORD_DEFAULT), $u[2], $u[3]]);
    }

    echo "Seeding Customers...\n";
    $customers = [
        ['Ahmad Dhani', '081234567890', 'Jakarta Selatan'],
        ['Maya Estianty', '081298765432', 'Surabaya'],
        ['Mulan Jameela', '081912345678', 'Bandung'],
        ['Al Ghazali', '085712340987', 'Jakarta Pusat'],
        ['El Rumi', '081345678901', 'London'],
    ];
    foreach ($customers as $c) {
        $stmt = $pdo->prepare("INSERT IGNORE INTO customers (name, phone, address) VALUES (?, ?, ?)");
        $stmt->execute($c);
    }

    echo "Seeding Spareparts...\n";
    $parts = [
        ['LCD Samsung A51', 10, 350000, 550000],
        ['Baterai iPhone 11', 15, 150000, 300000],
        ['Connector Charger Xiaomi Note 9', 20, 15000, 75000],
        ['LCD Oppo A5 2020', 8, 200000, 400000],
        ['Flexible On Off Vivo Y91', 25, 5000, 50000],
    ];
    foreach ($parts as $p) {
        $stmt = $pdo->prepare("INSERT INTO spareparts (name, stock, buy_price, sell_price) VALUES (?, ?, ?, ?)");
        $stmt->execute($p);
    }

    echo "Seeding Service Orders & Transactions...\n";
    // Get IDs
    $cust_ids = $pdo->query("SELECT id FROM customers")->fetchAll(PDO::FETCH_COLUMN);
    $part_ids = $pdo->query("SELECT id FROM spareparts")->fetchAll(PDO::FETCH_COLUMN);
    $tech_ids = $pdo->query("SELECT id FROM users WHERE role='teknisi'")->fetchAll(PDO::FETCH_COLUMN);

    $devices = ['Samsung A51', 'iPhone 11', 'Xiaomi Redmi Note 9', 'Oppo A5 2020', 'Vivo Y91'];
    $problems = ['Layar pecah', 'Baterai bocor', 'Tidak bisa cas', 'LCD Blank', 'Tombol mendlep'];
    $statuses = ['Pending', 'Checking', 'Waiting Approval', 'On Process', 'Completed', 'Taken'];

    for ($i = 1; $i <= 15; $i++) {
        $ticket = "SRV-TEST-" . str_pad($i, 3, '0', STR_PAD_LEFT);
        $cid = $cust_ids[array_rand($cust_ids)];
        $dev = $devices[array_rand($devices)];
        $prob = $problems[array_rand($problems)];
        $stat = $statuses[array_rand($statuses)];
        $tech = $tech_ids[array_rand($tech_ids)];
        
        $created_at = date('Y-m-d H:i:s', strtotime("-" . rand(1, 30) . " days"));
        $updated_at = $created_at;

        // Insert Order
        $stmt = $pdo->prepare("INSERT INTO service_orders (ticket_number, customer_id, device_name, complaint, physical_condition, status, technician_id, cost_estimation, created_at, updated_at) VALUES (?, ?, ?, ?, 'Lecet Pemakaian', ?, ?, 0, ?, ?)");
        $stmt->execute([$ticket, $cid, $dev, $prob, $stat, $tech, $created_at, $updated_at]);
        $oid = $pdo->lastInsertId();

        // Add history
        $stmt = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id, created_at) VALUES (?, 'New', 'Pending', 'Masuk service', 1, ?)");
        $stmt->execute([$oid, $created_at]);

        // If status > Pending, add logs
        if ($stat != 'Pending') {
             $stmt = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id, created_at) VALUES (?, 'Pending', ?, 'Update status', ?, ?)");
             $stmt->execute([$oid, $stat, $tech, date('Y-m-d H:i:s', strtotime($created_at . ' +1 hour'))]);
        }

        // Randomly add parts if Process/Completed/Taken
        if (in_array($stat, ['On Process', 'Completed', 'Taken']) && rand(0,1)) {
            $pid = $part_ids[array_rand($part_ids)];
            $stmt = $pdo->prepare("SELECT * FROM spareparts WHERE id = ?");
            $stmt->execute([$pid]);
            $part = $stmt->fetch();
            
            $stmt = $pdo->prepare("INSERT INTO service_parts (service_order_id, sparepart_id, qty, price, total) VALUES (?, ?, 1, ?, ?)");
            $stmt->execute([$oid, $pid, $part['sell_price'], $part['sell_price']]);
            
            $stmt = $pdo->prepare("UPDATE service_orders SET total_fee = total_fee + ? WHERE id = ?");
            $stmt->execute([$part['sell_price'], $oid]);
        }

        // If Taken, add payment info
        if ($stat == 'Taken') {
            $methods = ['Cash', 'Transfer', 'QRIS'];
            $method = $methods[array_rand($methods)];
            $stmt = $pdo->prepare("UPDATE service_orders SET payment_method = ?, warranty_end_date = DATE_ADD(NOW(), INTERVAL 7 DAY) WHERE id = ?");
            $stmt->execute([$method, $oid]);
        }
    }

    $pdo->commit();
    echo "Dummy Data Generated Successfully!\n";

} catch (Exception $e) {
    $pdo->rollBack();
    echo "Error: " . $e->getMessage();
}
?>
