<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) && basename($_SERVER['PHP_SELF']) != 'login.php' && basename($_SERVER['PHP_SELF']) != 'tracking.php') {
    header("Location: /servicehp/auth/login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Service HP System</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/servicehp/assets/css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- FontAwesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>

<?php if (isset($_SESSION['user_id'])): ?>
<div class="wrapper">
    <!-- Mobile Header -->
    <header class="mobile-header">
        <div class="mobile-logo d-flex align-center gap-2">
            <i class="fas fa-tools text-primary"></i> Service HP
        </div>
        <button class="mobile-toggle-btn" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>
    </header>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" onclick="toggleSidebar()" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <nav class="sidebar" id="mainSidebar">
        <div class="sidebar-header">
            <i class="fas fa-tools text-primary" style="margin-right: 0.75rem;"></i> Service HP
        </div>
        <div class="sidebar-menu">
            <a href="/servicehp/modules/dashboard/index.php" class="nav-link mb-2 <?php echo strpos($_SERVER['PHP_SELF'], 'dashboard') !== false ? 'active' : ''; ?>">
                <i class="fas fa-home"></i> Beranda
            </a>

            <?php if ($_SESSION['role'] == 'admin' || $_SESSION['role'] == 'kasir'): ?>
            <a href="/servicehp/modules/service/create.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'service/create.php') !== false ? 'active' : ''; ?>">
                <i class="fas fa-plus-circle"></i> Input Service
            </a>
            <?php endif; ?>

            <a href="/servicehp/modules/service/index.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'service/index.php') !== false || strpos($_SERVER['PHP_SELF'], 'service/view.php') !== false ? 'active' : ''; ?>">
                <i class="fas fa-clipboard-list"></i> Data Service
            </a>

            <a href="/servicehp/modules/stock/index.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'stock') !== false ? 'active' : ''; ?>">
                <i class="fas fa-box-open"></i> Stok Sparepart
            </a>

            <?php if ($_SESSION['role'] == 'admin'): ?>
            <div style="margin: 1rem 1rem 0.5rem; font-size: 0.75rem; font-weight: 700; color: var(--secondary-color); text-transform: uppercase; letter-spacing: 0.05em;">Admin</div>
            <a href="/servicehp/modules/report/daily.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'report') !== false ? 'active' : ''; ?>">
                <i class="fas fa-chart-bar"></i> Laporan Harian
            </a>
            <a href="/servicehp/modules/users/index.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'users') !== false ? 'active' : ''; ?>">
                <i class="fas fa-users-cog"></i> Kelola User
            </a>
            <a href="/servicehp/modules/settings/index.php" class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'settings') !== false ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i> Pengaturan Toko
            </a>
            <?php endif; ?>

            <div style="flex-grow: 1; min-height: 2rem;"></div>
            <a href="/servicehp/auth/logout.php" class="nav-link text-danger mt-auto" style="color: var(--danger-color); background-color: var(--danger-light); padding: 0.75rem 1rem; border-radius: 8px; font-weight: 600; text-align: center; justify-content: center;">
                <i class="fas fa-sign-out-alt"></i> Keluar Aplikasi
            </a>
        </div>
    </nav>
    
    <script>
        function toggleSidebar() {
            document.getElementById('mainSidebar').classList.toggle('open');
            document.getElementById('sidebarOverlay').classList.toggle('active');
        }
    </script>
    
    <!-- Main Content -->
    <main class="main-content">
        <!-- Topbar could be here -->
        <?php if (isset($_SESSION['flash_message'])): ?>
            <script>
                Swal.fire({
                    icon: '<?php echo $_SESSION['flash_type']; ?>',
                    title: '<?php echo $_SESSION['flash_message']; ?>',
                    showConfirmButton: false,
                    timer: 1500
                });
            </script>
            <?php 
            unset($_SESSION['flash_message']);
            unset($_SESSION['flash_type']);
            ?>
        <?php endif; ?>
<?php endif; ?>
