<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

// Stats Logic
// 1. Pending
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status = 'Pending'");
$pending_count = $stmt->fetchColumn();

// 2. On Process
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status IN ('Checking', 'Waiting Approval', 'On Process')");
$process_count = $stmt->fetchColumn();

// 3. Completed Today (Finished + Taken)
$today = date('Y-m-d');
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status IN ('Completed', 'Taken') AND DATE(updated_at) = '$today'");
$completed_today = $stmt->fetchColumn();

// 4. Income Today (Assuming Taken status means paid) - Net Income (After Discount)
$stmt = $pdo->query("SELECT SUM(total_fee - COALESCE(discount, 0)) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) = '$today'");
$income_today = $stmt->fetchColumn() ?: 0;

// 5. Warranty Claims Total
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE ticket_number LIKE 'WR-%'");
$warranty_count = $stmt->fetchColumn();

// Recent Orders
$stmt = $pdo->query("SELECT so.*, c.name as customer_name FROM service_orders so JOIN customers c ON so.customer_id = c.id ORDER BY so.created_at DESC LIMIT 10");
$recent_orders = $stmt->fetchAll();
?>

<div class="dashboard-header mb-4 d-flex justify-between align-center flex-wrap gap-4">
    <div>
        <h2 class="mb-1">Dashboard</h2>
        <p class="text-muted" style="margin: 0;">Selamat datang, <strong><?php echo $_SESSION['name']; ?></strong>!</p>
    </div>
    <div class="date-display">
        <span class="badge" style="background: var(--surface-color); border: 1px solid var(--border-color); color: var(--text-muted); font-size: 0.9rem; padding: 0.5rem 1rem;">
            <i class="far fa-calendar-alt"></i> <?php echo date('d F Y'); ?>
        </span>
    </div>
</div>

<!-- Stats Cards -->
<div class="grid-4 mb-4" style="grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); display: grid; gap: 1.5rem;">
    <div class="card d-flex align-center justify-between" style="border-left: 4px solid var(--warning-color);">
        <div>
            <h3 style="margin: 0; font-size: 2rem; color: var(--warning-color);"><?php echo $pending_count; ?></h3>
            <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Menunggu (Pending)</p>
        </div>
        <div style="font-size: 2.5rem; color: var(--warning-color); opacity: 0.2;">
            <i class="fas fa-clock"></i>
        </div>
    </div>
    
    <div class="card d-flex align-center justify-between" style="border-left: 4px solid var(--primary-color);">
        <div>
            <h3 style="margin: 0; font-size: 2rem; color: var(--primary-color);"><?php echo $process_count; ?></h3>
            <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Sedang Diproses</p>
        </div>
        <div style="font-size: 2.5rem; color: var(--primary-color); opacity: 0.2;">
            <i class="fas fa-tools"></i>
        </div>
    </div>

    <div class="card d-flex align-center justify-between" style="border-left: 4px solid var(--success-color);">
        <div>
            <h3 style="margin: 0; font-size: 2rem; color: var(--success-color);"><?php echo $completed_today; ?></h3>
            <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Selesai Hari Ini</p>
        </div>
        <div style="font-size: 2.5rem; color: var(--success-color); opacity: 0.2;">
            <i class="fas fa-check-circle"></i>
        </div>
    </div>

    <div class="card d-flex align-center justify-between" style="border-left: 4px solid #8b5cf6;">
        <div>
            <h3 style="margin: 0; font-size: 1.8rem; color: #8b5cf6;">Rp <?php echo number_format($income_today, 0, ',', '.'); ?></h3>
            <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Omset Hari Ini</p>
        </div>
        <div style="font-size: 2.5rem; color: #8b5cf6; opacity: 0.2;">
            <i class="fas fa-wallet"></i>
        </div>
    </div>
    <div class="card d-flex align-center justify-between" style="border-left: 4px solid var(--info-color, #3b82f6);">
        <div>
            <h3 style="margin: 0; font-size: 2rem; color: var(--info-color, #3b82f6);"><?php echo $warranty_count; ?></h3>
            <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Total Klaim Garansi</p>
        </div>
        <div style="font-size: 2.5rem; color: var(--info-color, #3b82f6); opacity: 0.2;">
            <i class="fas fa-tools"></i>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<div class="card">
    <div class="card-header d-flex justify-between align-center flex-wrap gap-4">
        <h3 style="margin: 0; font-size: 1.25rem;">Servis Terbaru</h3>
        <?php if ($_SESSION['role'] == 'admin' || $_SESSION['role'] == 'kasir'): ?>
        <a href="/servicehp/modules/service/create.php" class="btn-primary">
            <i class="fas fa-plus"></i> Input Service Baru
        </a>
        <?php endif; ?>
    </div>
    
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Tiket</th>
                    <th>Customer</th>
                    <th>Perangkat</th>
                    <th>Masalah</th>
                    <th>Status</th>
                    <th>Tanggal</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($recent_orders) > 0): ?>
                    <?php foreach ($recent_orders as $order): ?>
                        <?php
                        $status_colors = [
                            'Pending' => ['bg' => '#fef3c7', 'text' => '#d97706'],
                            'Checking' => ['bg' => '#dbeafe', 'text' => '#2563eb'],
                            'On Process' => ['bg' => '#dbeafe', 'text' => '#2563eb'],
                            'Waiting Approval' => ['bg' => '#ffedd5', 'text' => '#c2410c'],
                            'Completed' => ['bg' => '#dcfce7', 'text' => '#166534'],
                            'Taken' => ['bg' => '#f3f4f6', 'text' => '#4b5563'],
                            'Cancelled' => ['bg' => '#fee2e2', 'text' => '#991b1b']
                        ];
                        $sc = $status_colors[$order['status']] ?? ['bg' => '#f3f4f6', 'text' => '#4b5563'];
                        ?>
                    <tr>
                        <td>
                            <span style="font-weight: 600; font-family: monospace; color: var(--primary-color);">
                                <?php echo $order['ticket_number']; ?>
                                <?php if (strpos($order['ticket_number'], 'WR-') === 0): ?>
                                    <span class="badge" style="background: #fef08a; color: #854d0e; font-size: 0.6rem; padding: 0.1rem 0.3rem;">GARANSI</span>
                                <?php endif; ?>
                            </span>
                        </td>
                        <td>
                            <div style="font-weight: 500;"><?php echo $order['customer_name']; ?></div>
                            <small class="text-muted" style="font-size: 0.8rem;">
                                <?php 
                                // Fetch phone for WhatsApp link
                                $stmt_c = $pdo->prepare("SELECT phone FROM customers WHERE id = ?");
                                $stmt_c->execute([$order['customer_id']]);
                                echo $stmt_c->fetchColumn(); 
                                ?>
                            </small>
                        </td>
                        <td><?php echo $order['device_name']; ?></td>
                        <td><span class="text-muted" style="font-size: 0.9rem;"><?php echo substr($order['complaint'], 0, 30) . (strlen($order['complaint']) > 30 ? '...' : ''); ?></span></td>
                        <td>
                            <span class="badge" style="background-color: <?php echo $sc['bg']; ?>; color: <?php echo $sc['text']; ?>;">
                                <?php echo $order['status']; ?>
                            </span>
                        </td>
                        <td><?php echo date('d M Y', strtotime($order['created_at'])); ?></td>
                        <td class="text-center">
                            <a href="/servicehp/modules/service/view.php?id=<?php echo $order['id']; ?>" class="btn-primary" style="padding: 0.4rem; background: var(--primary-light); color: var(--primary-color);">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">Belum ada data service hari ini.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
