<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';
echo '<link rel="stylesheet" href="../../assets/css/print_report.css">';

// Date Range Filter
$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// 1. Service Stats
$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE DATE(created_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_received = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE status = 'Completed' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_completed = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_taken = $stmt->fetchColumn();

// Total Claims
$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE ticket_number LIKE 'WR-%' AND DATE(created_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_claims = $stmt->fetchColumn();

// 2. Financial Stats
// Omset Kotor (Gross) - Diskon
$stmt = $pdo->prepare("SELECT SUM(total_fee - COALESCE(discount, 0)) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$gross_income = $stmt->fetchColumn() ?: 0;

// Breakdown Payment Method
$stmt = $pdo->prepare("SELECT payment_method, SUM(total_fee - COALESCE(discount, 0)) as total FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ? GROUP BY payment_method");
$stmt->execute([$start_date, $end_date]);
$payment_breakdown = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Calculate Modal (Spareparts used in Taken services)
$query_modal = "SELECT SUM(sp.qty * s.buy_price) 
                FROM service_parts sp 
                JOIN spareparts s ON sp.sparepart_id = s.id 
                JOIN service_orders so ON sp.service_order_id = so.id 
                WHERE so.status = 'Taken' AND DATE(so.updated_at) BETWEEN ? AND ?";
$stmt = $pdo->prepare($query_modal);
$stmt->execute([$start_date, $end_date]);
$total_modal = $stmt->fetchColumn() ?: 0;

$net_profit = $gross_income - $total_modal;

// 3. List of Transactions
$stmt = $pdo->prepare("SELECT * FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ? ORDER BY updated_at DESC");
$stmt->execute([$start_date, $end_date]);
$transactions = $stmt->fetchAll();
?>

<div class="card report-card">
    <div class="card-header mb-4 d-print-none d-flex justify-between align-center flex-wrap gap-4">
        <h2 style="margin: 0;">Laporan Harian</h2>
        
        <form action="" method="GET" class="d-flex flex-wrap gap-2 align-center">
            <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>" style="width: auto;">
            <span>s/d</span>
            <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>" style="width: auto;">
            <button type="submit" class="btn-primary" style="width: auto;">Filter</button>
        </form>

        <div class="d-flex gap-2">
            <!-- Print Button -->
            <a href="print.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>" target="_blank" class="btn-primary" style="width: auto; background: var(--text-color); text-decoration: none;">
                <i class="fas fa-print"></i> PDF
            </a>

            <!-- WA Owner Button -->
            <?php
            // Prepare WA Message
            $wa_message = "*LAPORAN HARIAN MAHKOTA SERVICE*\n";
            $wa_message .= "Periode: " . date('d/m/Y', strtotime($start_date)) . " - " . date('d/m/Y', strtotime($end_date)) . "\n\n";
            $wa_message .= "Order Masuk: $total_received\n";
            $wa_message .= "Order Selesai: $total_completed\n";
            $wa_message .= "Order Diambil: $total_taken\n";
            $wa_message .= "Klaim Garansi: $total_claims\n\n";
            $wa_message .= "*Omset: Rp " . number_format($gross_income, 0, ',', '.') . "*\n";
            $wa_message .= "*Profit: Rp " . number_format($net_profit, 0, ',', '.') . "*\n\n";
            $wa_message .= "*[File PDF Terlampir]*\n";
            $wa_message .= "Detail: http://localhost/servicehp/modules/report/daily.php?start_date=$start_date&end_date=$end_date";
            
            // Dummy Owner Number
            $owner_phone = "6282110291771"; 
            $wa_link = "https://wa.me/$owner_phone?text=" . urlencode($wa_message);
            ?>
            <a href="<?php echo $wa_link; ?>" target="_blank" class="btn-primary" style="width: auto; background: #25D366; text-decoration: none;">
                <i class="fab fa-whatsapp"></i> WA Bos
            </a>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid-4 mb-4" style="grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); display: grid; gap: 1.5rem;">
        <div class="card p-3" style="border-left: 4px solid var(--info-color); background: #eff6ff;">
            <div class="d-flex justify-between align-center">
                <div>
                     <h3 style="margin: 0; font-size: 1.8rem; color: var(--info-color);"><?php echo $total_received; ?></h3>
                     <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Service Masuk</p>
                </div>
                <div style="font-size: 2rem; color: var(--info-color); opacity: 0.3;"><i class="fas fa-tools"></i></div>
            </div>
        </div>

        <div class="card p-3" style="border-left: 4px solid var(--success-color); background: #f0fdf4;">
            <div class="d-flex justify-between align-center">
                <div>
                     <h3 style="margin: 0; font-size: 1.8rem; color: var(--success-color);"><?php echo $total_completed; ?></h3>
                     <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Selesai</p>
                </div>
                 <div style="font-size: 2rem; color: var(--success-color); opacity: 0.3;"><i class="fas fa-check-circle"></i></div>
            </div>
        </div>

        <div class="card p-3" style="border-left: 4px solid var(--warning-color); background: #fefce8;">
            <div class="d-flex justify-between align-center mb-2">
                <div>
                     <h3 style="margin: 0; font-size: 1.5rem; color: var(--warning-color);">Rp <?php echo number_format($gross_income, 0, ',', '.'); ?></h3>
                     <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Omset (Gross)</p>
                </div>
                 <div style="font-size: 2rem; color: var(--warning-color); opacity: 0.3;"><i class="fas fa-coins"></i></div>
            </div>
            <div style="font-size: 0.8rem; border-top: 1px dashed rgba(0,0,0,0.1); paddingTop: 5px;">
                <?php 
                foreach($payment_breakdown as $method => $amount) {
                    echo "<div class='d-flex justify-between'><span>$method:</span> <span>" . number_format($amount, 0, ',', '.') . "</span></div>";
                }
                ?>
            </div>
        </div>

        <div class="card p-3" style="border-left: 4px solid var(--primary-color); background: #faf5ff;">
            <div class="d-flex justify-between align-center">
                <div>
                     <h3 style="margin: 0; font-size: 1.5rem; color: var(--primary-color);">Rp <?php echo number_format($net_profit, 0, ',', '.'); ?></h3>
                     <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Profit Bersih</p>
                </div>
                 <div style="font-size: 2rem; color: var(--primary-color); opacity: 0.3;"><i class="fas fa-chart-line"></i></div>
            </div>
        </div>

        <div class="card p-3" style="border-left: 4px solid #6b7280; background: #f3f4f6;">
            <div class="d-flex justify-between align-center">
                <div>
                     <h3 style="margin: 0; font-size: 1.8rem; color: #4b5563;"><?php echo $total_claims; ?></h3>
                     <p class="text-muted" style="margin: 0; font-size: 0.9rem;">Klaim Garansi</p>
                </div>
                 <div style="font-size: 2rem; color: #6b7280; opacity: 0.3;"><i class="fas fa-tools"></i></div>
            </div>
        </div>
    </div>

    <!-- Transaction Table -->
    <h3 class="mb-3">Transaksi Selesai & Diambil</h3>
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th>Tiket</th>
                    <th>Perangkat</th>
                    <th>Kerusakan</th>
                    <th class="text-end">Total Biaya</th>
                    <th class="text-end">Diskon</th>
                    <th class="text-end">Total Akhir</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($transactions) > 0): ?>
                    <?php foreach ($transactions as $t): ?>
                    <?php 
                        $discount = $t['discount'] ?? 0;
                        $final_fee = $t['total_fee'] - $discount;
                    ?>
                    <tr>
                        <td><span style="font-family: monospace; font-weight: 600; color: var(--primary-color);"><?php echo $t['ticket_number']; ?></span></td>
                        <td><?php echo $t['device_name']; ?></td>
                        <td><?php echo $t['complaint']; ?></td>
                        <td class="text-end">Rp <?php echo number_format($t['total_fee'], 0, ',', '.'); ?></td>
                        <td class="text-end text-danger">
                            <?php echo ($discount > 0) ? '- Rp ' . number_format($discount, 0, ',', '.') : '-'; ?>
                        </td>
                        <td class="text-end font-bold">Rp <?php echo number_format($final_fee, 0, ',', '.'); ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="6" class="text-center py-4 text-muted">Belum ada transaksi selesai pada periode ini.</td></tr>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr style="font-weight: bold; background: #f9fafb;">
                    <td colspan="5" class="text-end">Total Omset Bersih</td>
                    <td class="text-end">Rp <?php echo number_format($gross_income, 0, ',', '.'); ?></td>
                </tr>
            </tfoot>
        </table>
    </div>
    
    <div class="mt-3 text-muted d-print-none">
        <small><i class="fas fa-info-circle"></i> Profit Bersih dihitung dari Total Biaya - Modal Sparepart yang digunakan pada service tersebut.</small>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
