<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $service_id = $_POST['service_id'];
    $sparepart_id = $_POST['sparepart_id'];
    $qty = $_POST['qty'];

    try {
        $pdo->beginTransaction();

        // 1. Get Sparepart Data & Check Stock
        $stmt = $pdo->prepare("SELECT * FROM spareparts WHERE id = ? FOR UPDATE");
        $stmt->execute([$sparepart_id]);
        $part = $stmt->fetch();

        if ($part['stock'] < $qty) {
            throw new Exception("Stok tidak cukup! Sisa stok: " . $part['stock']);
        }

        // 2. Insert into service_parts
        $total_price = $part['sell_price'] * $qty;
        $stmt = $pdo->prepare("INSERT INTO service_parts (service_order_id, sparepart_id, qty, price, total) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$service_id, $sparepart_id, $qty, $part['sell_price'], $total_price]);

        // 3. Deduct Stock
        $new_stock = $part['stock'] - $qty;
        $stmt = $pdo->prepare("UPDATE spareparts SET stock = ? WHERE id = ?");
        $stmt->execute([$new_stock, $sparepart_id]);

        // 4. Log Stock History
        $stmt = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'out', ?, ?)");
        $stmt->execute([$sparepart_id, $qty, "Digunakan untuk Service Tiket ID: $service_id"]);

        // 5. Update Total Fee in Service Order
        // Get current total fee (Service Fee + Parts)
        // Recalculate all parts total
        $stmt = $pdo->prepare("SELECT SUM(total) FROM service_parts WHERE service_order_id = ?");
        $stmt->execute([$service_id]);
        $all_parts_total = $stmt->fetchColumn() ?: 0;
        
        // We assume 'total_fee' includes service fee + parts. 
        // Strategy: Get current total_fee, assume it was correct, add new part total? 
        // Better Strategy: Have a base 'service_fee' column? 
        // For now, let's just ADD to the existing total_fee. This assumes total_fee initially only contained the estimated/agreed service fee.
        // Wait, 'cost_estimation' is estimation. 'total_fee' is final.
        // Let's UPDATE total_fee = total_fee + new_part_total.
        
        $stmt = $pdo->prepare("UPDATE service_orders SET total_fee = total_fee + ? WHERE id = ?");
        $stmt->execute([$total_price, $service_id]);

        $pdo->commit();

        $_SESSION['flash_message'] = "Sparepart berhasil ditambahkan!";
        $_SESSION['flash_type'] = "success";
        header("Location: view.php?id=$service_id");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}
?>
