<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

// Generate Ticket Number (Auto-fill suggestion)
$month = date('Ym');
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE ticket_number LIKE 'SRV-$month%'");
$count = $stmt->fetchColumn();
$next_ticket = "SRV-" . $month . "-" . str_pad($count + 1, 3, '0', STR_PAD_LEFT);
?>

<div class="card">
    <div class="card-header mb-4">
        <h2 style="margin: 0;"><i class="fas fa-plus-circle"></i> Input Service Baru</h2>
    </div>

    <form action="store.php" method="POST">
        <div class="grid-2 gap-4">
            
            <!-- Left Column: Customer & Device Info -->
            <div>
                <h4 class="mb-3" style="border-bottom: 2px solid var(--border-color); padding-bottom: 10px; color: var(--primary-color);">
                    <i class="fas fa-user"></i> Data Customer & Perangkat
                </h4>
                
                <div class="form-group mb-3">
                    <label class="form-label">Nomor Tiket (Auto)</label>
                    <input type="text" name="ticket_number" class="form-control" value="<?php echo $next_ticket; ?>" readonly style="background-color: var(--background-color); cursor: not-allowed;">
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Nama Customer <span class="text-danger">*</span></label>
                    <input type="text" name="customer_name" class="form-control" required placeholder="Contoh: Budi Santoso">
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Nomor HP/WA <span class="text-danger">*</span></label>
                    <input type="tel" name="customer_phone" class="form-control" required placeholder="08123456789">
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Alamat</label>
                    <textarea name="customer_address" class="form-control" rows="2" placeholder="Alamat lengkap customer"></textarea>
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Tipe / Nama Perangkat <span class="text-danger">*</span></label>
                    <input type="text" name="device_name" class="form-control" required placeholder="Contoh: Samsung S21, iPhone 11">
                </div>
            </div>

            <!-- Right Column: Problems, Conditions & Checklist -->
            <div>
                <h4 class="mb-3" style="border-bottom: 2px solid var(--border-color); padding-bottom: 10px; color: var(--primary-color);">
                    <i class="fas fa-tools"></i> Keluhan & Kondisi
                </h4>

                <div class="form-group mb-3">
                    <label class="form-label">Keluhan Utama <span class="text-danger">*</span></label>
                    <textarea name="complaint" class="form-control" rows="3" required placeholder="Jelaskan kerusakan hp..."></textarea>
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Kondisi Fisik & Checklist</label>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 0.5rem; background: var(--background-color); padding: 1rem; border-radius: var(--border-radius); border: 1px solid var(--border-color);">
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Lecet Pemakaian"> Lecet Pemakaian</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Penyok/Dent"> Penyok (Dent)</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Layar Retak"> Layar Retak</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Backdoor Retak"> Backdoor Retak</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Tombol Keras"> Tombol Keras</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Sim Tray Hilang"> Sim Tray Hilang</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="No Signal"> No Signal</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Bootloop"> Bootloop</label>
                        <label class="d-flex align-center gap-2"><input type="checkbox" name="conditions[]" value="Mati Total"> Mati Total</label>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Kelengkapan</label>
                    <input type="text" name="completeness" class="form-control" placeholder="Contoh: Unit Only, Ada Charger, Sim Card ada">
                </div>

                <div class="grid-2 gap-3">
                    <div class="form-group mb-3">
                        <label class="form-label">Perkiraan Biaya (Est)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="number" name="cost_estimation" class="form-control" placeholder="0">
                        </div>
                    </div>
                    
                    <div class="form-group mb-3">
                        <label class="form-label">Uang Muka (DP)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="number" name="down_payment" class="form-control" placeholder="0">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4 text-end">
            <button type="submit" class="btn-primary" style="padding: 0.8rem 2rem; font-size: 1rem;">
                <i class="fas fa-save me-2"></i> Simpan Service & Cetak Struk
            </button>
        </div>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
