<?php
session_start();
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0; // service_parts id
$service_id = $_GET['service_id'] ?? 0;

if (!$id || !$service_id) die("Invalid Request");

try {
    $pdo->beginTransaction();

    // 1. Get Service Part Data
    $stmt = $pdo->prepare("SELECT * FROM service_parts WHERE id = ?");
    $stmt->execute([$id]);
    $service_part = $stmt->fetch();

    if (!$service_part) die("Data part tidak ditemukan");

    $sparepart_id = $service_part['sparepart_id'];
    $qty = $service_part['qty'];
    $total_price = $service_part['total'];

    // 2. Delete from service_parts
    $stmt = $pdo->prepare("DELETE FROM service_parts WHERE id = ?");
    $stmt->execute([$id]);

    // 3. Restore Stock in Spareparts
    $stmt = $pdo->prepare("UPDATE spareparts SET stock = stock + ? WHERE id = ?");
    $stmt->execute([$qty, $sparepart_id]);

    // 4. Log Stock History (Restore)
    $stmt = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'in', ?, ?)");
    $stmt->execute([$sparepart_id, $qty, "Batal pakai di Service ID: $service_id"]);

    // 5. Update Total Fee (Subtract cost)
    $stmt = $pdo->prepare("UPDATE service_orders SET total_fee = total_fee - ? WHERE id = ?");
    $stmt->execute([$total_price, $service_id]);

    $pdo->commit();

    $_SESSION['flash_message'] = "Sparepart dibatalkan/dihapus!";
    $_SESSION['flash_type'] = "success";
    header("Location: view.php?id=$service_id");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    die("Error: " . $e->getMessage());
}
?>
