<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';

$query = "SELECT so.*, c.name as customer_name FROM service_orders so JOIN customers c ON so.customer_id = c.id WHERE 1=1";
$params = [];

if ($search) {
    $query .= " AND (so.ticket_number LIKE ? OR c.name LIKE ? OR so.device_name LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if ($status) {
    $query .= " AND so.status = ?";
    $params[] = $status;
}

$query .= " ORDER BY so.created_at DESC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$orders = $stmt->fetchAll();
?>

<div class="card">
    <div class="card-header d-flex justify-between align-center flex-wrap gap-4 mb-4">
        <h2 style="margin: 0;">Data Service</h2>
        <a href="create.php" class="btn-primary">
            <i class="fas fa-plus"></i> Input Baru
        </a>
    </div>

    <!-- Filter -->
    <form class="mb-4 d-flex flex-wrap gap-2" method="GET">
        <div style="flex: 1; min-width: 200px;">
            <input type="text" name="search" class="form-control" placeholder="Cari Tiket / Nama / HP..." value="<?php echo htmlspecialchars($search); ?>">
        </div>
        <div style="flex: 0 0 200px;">
            <select name="status" class="form-control">
                <option value="">Semua Status</option>
                <option value="Pending" <?php if($status == 'Pending') echo 'selected'; ?>>Pending</option>
                <option value="Checking" <?php if($status == 'Checking') echo 'selected'; ?>>Checking</option>
                <option value="On Process" <?php if($status == 'On Process') echo 'selected'; ?>>On Process</option>
                <option value="Completed" <?php if($status == 'Completed') echo 'selected'; ?>>Completed</option>
                <option value="Taken" <?php if($status == 'Taken') echo 'selected'; ?>>Taken</option>
            </select>
        </div>
        <button type="submit" class="btn-primary" style="width: auto;">
            <i class="fas fa-search"></i> Filter
        </button>
        <?php if($search || $status): ?>
            <a href="index.php" class="btn-primary btn-danger" style="width: auto;">Reset</a>
        <?php endif; ?>
    </form>

    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Tiket</th>
                    <th>Customer</th>
                    <th>Perangkat</th>
                    <th>Keluhan</th>
                    <th>Status</th>
                    <th>Tanggal</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($orders) > 0): ?>
                    <?php foreach ($orders as $order): ?>
                        <?php
                        $status_colors = [
                            'Pending' => ['bg' => '#fef3c7', 'text' => '#d97706'],
                            'Checking' => ['bg' => '#dbeafe', 'text' => '#2563eb'],
                            'On Process' => ['bg' => '#dbeafe', 'text' => '#2563eb'],
                            'Waiting Approval' => ['bg' => '#ffedd5', 'text' => '#c2410c'],
                            'Completed' => ['bg' => '#dcfce7', 'text' => '#166534'],
                            'Taken' => ['bg' => '#f3f4f6', 'text' => '#4b5563'],
                            'Cancelled' => ['bg' => '#fee2e2', 'text' => '#991b1b']
                        ];
                        $sc = $status_colors[$order['status']] ?? ['bg' => '#f3f4f6', 'text' => '#4b5563'];
                        ?>
                    <tr>
                        <td>
                             <span style="font-weight: 600; font-family: monospace; color: var(--primary-color);"><?php echo $order['ticket_number']; ?></span>
                        </td>
                        <td><?php echo $order['customer_name']; ?></td>
                        <td><?php echo $order['device_name']; ?></td>
                        <td><span class="text-muted" style="font-size: 0.9rem;"><?php echo substr($order['complaint'], 0, 30) . (strlen($order['complaint']) > 30 ? '...' : ''); ?></span></td>
                        <td>
                            <span class="badge" style="background-color: <?php echo $sc['bg']; ?>; color: <?php echo $sc['text']; ?>;">
                                <?php echo $order['status']; ?>
                            </span>
                        </td>
                        <td><?php echo date('d/m/Y', strtotime($order['created_at'])); ?></td>
                        <td class="text-center">
                            <div class="d-flex justify-center gap-2">
                                <a href="view.php?id=<?php echo $order['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; background: var(--primary-light); color: var(--primary-color);" title="Lihat">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
                                    <a href="edit.php?id=<?php echo $order['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; background: var(--warning-color); border-color: var(--warning-color);" title="Edit / Update">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="delete.php?id=<?php echo $order['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; background: var(--danger-color); border-color: var(--danger-color);" title="Hapus" onclick="return confirm('Yakin ingin menghapus data tiket ini secara permanen?');">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">Belum ada data service.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
