<?php
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT so.*, c.name as customer_name, c.phone as customer_phone, c.address as customer_address, u.name as technician_name 
                       FROM service_orders so 
                       JOIN customers c ON so.customer_id = c.id 
                       LEFT JOIN users u ON so.technician_id = u.id 
                       WHERE so.id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) die("Data tidak ditemukan.");

// Fetch parts
$stmt_p = $pdo->prepare("SELECT sp.*, s.name FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE sp.service_order_id = ?");
$stmt_p->execute([$id]);
$parts = $stmt_p->fetchAll();

// Fetch settings
$stmt_set = $pdo->query("SELECT * FROM settings WHERE id = 1");
$setting = $stmt_set->fetch();
// Default fallbacks
$store_name = $setting['store_name'] ?? 'Mahkota Service';
$store_address = $setting['store_address'] ?? 'Jl. Raya Utama';
$store_phone = $setting['store_phone'] ?? '-';
$printer_width = $setting['printer_width'] ?? '80mm';
$footer_note = $setting['footer_note'] ?? 'Terima Kasih';
$store_logo = $setting['store_logo'] ?? '';

// Font size adjustment for 58mm
$font_size = ($printer_width == '58mm') ? '11px' : '14px';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Invoice - <?php echo $service['ticket_number']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Courier Prime', monospace; /* Thermal printer look */
            font-size: <?php echo $font_size; ?>;
            color: #000;
            background: #fff;
            margin: 0;
            padding: 20px;
        }
        .invoice-box {
            max-width: <?php echo $printer_width; ?>;
            margin: auto;
            border: 1px dashed #ccc;
            padding: <?php echo ($printer_width == '58mm') ? '5px' : '10px'; ?>;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
        }
        .header h2 { margin: 0; font-size: <?php echo ($printer_width == '58mm') ? '14px' : '18px'; ?>; text-transform: uppercase; }
        .header p { margin: 2px 0; font-size: <?php echo ($printer_width == '58mm') ? '10px' : '12px'; ?>; }
        
        .info {
            margin-bottom: 10px;
            border-bottom: 1px dashed #000;
            padding-bottom: 10px;
        }
        .info p { margin: 2px 0; display: flex; justify-content: space-between; }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        th { text-align: left; border-bottom: 1px solid #000; }
        td { padding: 4px 0; vertical-align: top; }
        
        .totals {
            border-top: 1px dashed #000;
            padding-top: 5px;
        }
        .totals p {
            margin: 2px 0;
            display: flex;
            justify-content: space-between;
        }
        .grand-total {
            font-weight: bold;
            font-size: <?php echo ($printer_width == '58mm') ? '13px' : '16px'; ?>;
            border-top: 1px solid #000;
            margin-top: 5px;
            padding-top: 5px;
        }
        
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: <?php echo ($printer_width == '58mm') ? '9px' : '10px'; ?>;
        }

        .btn-print {
            display: block;
            width: 100%;
            padding: 10px;
            background: #333;
            color: white;
            text-align: center;
            text-decoration: none;
            margin-bottom: 20px;
            font-family: sans-serif;
            border-radius: 5px;
        }
        
        @media print {
            body { padding: 0; margin: 0; width: <?php echo $printer_width; ?>; }
            .invoice-box { border: none; width: 100%; max-width: none; padding: 0; }
            .btn-print { display: none; }
            @page {
                size: <?php echo $printer_width; ?> auto; /* Auto height for roll paper */
                margin: 0;
            }
        }
    </style>
</head>
<body>

    <div class="invoice-box">
        <a href="#" onclick="window.print()" class="btn-print">Cetak Struk (Print)</a>

        <div class="header">
            <?php if ($store_logo): ?>
                <img src="../../<?php echo $store_logo; ?>" style="max-height: <?php echo ($printer_width == '58mm') ? '40px' : '60px'; ?>; margin-bottom: 5px;">
            <?php endif; ?>
            <h2><?php echo strtoupper($store_name); ?></h2>
            <p><?php echo $store_address; ?></p>
            <p>Telp/WA: <?php echo $store_phone; ?></p>
        </div>

        <div class="info">
            <p><span>Tgl:</span> <span><?php echo date('d/m/Y H:i'); ?></span></p>
            <p><span>Tiket:</span> <span><?php echo $service['ticket_number']; ?></span></p>
            <p><span>Cust:</span> <span><?php echo $service['customer_name']; ?></span></p>
            <p><span>Unit:</span> <span><?php echo $service['device_name']; ?></span></p>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Item</th>
                    <th style="text-align: right;">Total</th>
                </tr>
            </thead>
            <tbody>
                <!-- Jasa Service -->
                <?php if ($service['cost_estimation'] > 0): ?>
                <tr>
                    <td>Jasa Service<br><small><?php echo nl2br($service['complaint']); ?></small></td>
                    <td style="text-align: right;">Rp <?php echo number_format($service['cost_estimation'], 0, ',', '.'); ?></td>
                </tr>
                <?php endif; ?>

                <!-- Spareparts -->
                <?php foreach ($parts as $p): ?>
                <tr>
                    <td><?php echo $p['name']; ?> x<?php echo $p['qty']; ?></td>
                    <td style="text-align: right;">Rp <?php echo number_format($p['total'], 0, ',', '.'); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="totals">
            <p><span>Total:</span> <span>Rp <?php echo number_format($service['total_fee'], 0, ',', '.'); ?></span></p>
            
            <?php if ($service['discount'] > 0): ?>
            <p><span>Diskon:</span> <span>- Rp <?php echo number_format($service['discount'], 0, ',', '.'); ?></span></p>
            <?php endif; ?>

            <p><span>DP:</span> <span>- Rp <?php echo number_format($service['down_payment'], 0, ',', '.'); ?></span></p>
            
            <?php
            $total_akhir = $service['total_fee'] - $service['discount'];
            $sisa = $total_akhir - $service['down_payment']; // Recalculate sisa
            ?>

            <p class="grand-total"><span>Sisa:</span> <span>Rp <?php echo number_format($sisa, 0, ',', '.'); ?></span></p>
            
            <?php if ($service['status'] == 'Taken'): ?>
            <p style="margin-top: 10px; text-align: center; font-weight: bold;">-- LUNAS --</p>
            <p style="text-align: center;">Via: <?php echo $service['payment_method']; ?></p>
            <?php endif; ?>

            <?php if ($service['warranty_end_date']): ?>
            <div style="margin-top: 10px; border-top: 1px dashed #000; padding-top: 5px; text-align: center;">
                <p style="font-weight: bold;">INFO GARANSI</p>
                <p>Berlaku s/d: <?php echo date('d M Y', strtotime($service['warranty_end_date'])); ?></p>
                <p style="font-size: 0.9em;">(Syarat: Segel harus utuh & tidak cacat fisik)</p>
            </div>
            <?php endif; ?>
        </div>

        <div class="footer">
            <p><?php echo nl2br($footer_note); ?></p>
        </div>
    </div>

</body>
</html>
