<?php
require_once '../../config/database.php';
$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT ticket_number, device_name, created_at, complaint FROM service_orders WHERE id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) die("Data not found");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Label Service</title>
    <style>
        body {
            font-family: 'Courier New', monospace;
            width: 58mm; /* Standard Thermal Label Width */
            margin: 0;
            padding: 5px;
            text-align: center;
        }
        .label-container {
            border: 2px dashed #000;
            padding: 10px;
            border-radius: 5px;
        }
        h2 { margin: 0; font-size: 16px; }
        h3 { margin: 5px 0; font-size: 20px; font-weight: bold; }
        p { margin: 2px 0; font-size: 12px; }
        .date { font-size: 10px; margin-top: 5px; }
        @media print {
            .no-print { display: none; }
            body { margin: 0; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="label-container">
        <h2>SERVICE HP</h2>
        <h3 style="font-size: 1.2rem;"><?php echo $service['ticket_number']; ?></h3>
        <p><strong><?php echo substr($service['device_name'], 0, 20); ?></strong></p>
        <p style="font-size: 10px;"><?php echo substr($service['complaint'], 0, 30); ?></p>
        <div class="date"><?php echo date('d/m/Y H:i', strtotime($service['created_at'])); ?></div>
    </div>
    <br>
    <button class="no-print" onclick="window.close()">Tutup</button>
</body>
</html>
