<?php
require_once '../../config/database.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $final_amount = $_POST['final_amount']; // This might be unused now as we calc on fly or just use for validation? 
    // Actually, let's rely on server side calc or trust the input?
    // Better to just update the discount and status.
    
    $payment_method = $_POST['payment_method'];
    
    // Additional Data
    // Clean received amount (remove dots)
    $received_amount = isset($_POST['received_amount']) ? str_replace('.', '', $_POST['received_amount']) : 0;
    
    // Handle Discount
    $discount = isset($_POST['discount']) ? str_replace('.', '', $_POST['discount']) : 0;

    $ref_number = $_POST['ref_number'] ?? '';
    
    // Determine payment detail string
    $payment_detail = $payment_method;
    if ($payment_method == 'Cash') {
        // Optional: Store received amount and change
    } else {
        if (!empty($ref_number)) {
            $payment_detail .= " (Ref: $ref_number)";
        }
    }

    try {
        // Calculate Warranty if not manually set
        $stmt_check_warranty = $pdo->prepare("SELECT warranty_end_date FROM service_orders WHERE id = ?");
        $stmt_check_warranty->execute([$id]);
        $current_warranty = $stmt_check_warranty->fetchColumn();

        $warranty_sql = "";
        $warranty_params = [];
        
        if (empty($current_warranty)) {
            // Find max warranty days from parts used
            $stmt_max_warranty = $pdo->prepare("SELECT MAX(s.warranty_days) as max_days FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE sp.service_order_id = ?");
            $stmt_max_warranty->execute([$id]);
            $max_days = $stmt_max_warranty->fetchColumn();

            if ($max_days > 0) {
                $warranty_sql = ", warranty_end_date = DATE_ADD(CURRENT_DATE(), INTERVAL ? DAY)";
                $warranty_params[] = $max_days;
            }
        }

        // Update Order
        $sql = "UPDATE service_orders SET status = 'Taken', payment_method = ?, discount = ?, updated_at = NOW() $warranty_sql WHERE id = ?";
        $params = array_merge([$payment_detail, $discount], $warranty_params, [$id]);
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);


        // Insert History
        $user_id = $_SESSION['user_id'];
        $notes = "Unit diambil customer. Pembayaran lunas via $payment_detail.";
        
        $stmt_hist = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id, created_at) VALUES (?, 'Completed', 'Taken', ?, ?, NOW())");
        $stmt_hist->execute([$id, $notes, $user_id]);

        // Reduce Stock? (Already done when adding parts? No, usually stock is deducted when part is added to service. 
        // If system design deducts stock upon 'Taken', do it here. 
        // Based on previous files, 'add_part.php' likely deducts stock or allocates it. 
        // Let's assume stock was already handled or check 'add_part.php' logic. 
        // Usually, best practice is to deduct when part is used. 
        // If the previous logic in add_part didn't deduct, we should do it. 
        // But for now, let's focus on status update.)
        
        $_SESSION['flash_message'] = "Pembayaran berhasil! Unit telah diambil.";
        $_SESSION['flash_type'] = "success";
        header("Location: view.php?id=$id");
        exit();

    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>
