<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $status = $_POST['status'];
    $total_fee = $_POST['total_fee'];
    $notes = $_POST['notes'];
    $warranty_end_date = !empty($_POST['warranty_end_date']) ? $_POST['warranty_end_date'] : null;
    $user_id = $_SESSION['user_id'];

    // Get Old Status
    $stmt = $pdo->prepare("SELECT status FROM service_orders WHERE id = ?");
    $stmt->execute([$id]);
    $old_data = $stmt->fetch();
    $old_status = $old_data['status'];

    try {
        $pdo->beginTransaction();

        // 1. Update Service Order
        
        // Auto Calculate Warranty if Status is Taken and Warranty is not set manually
        if ($status == 'Taken' && empty($warranty_end_date)) {
            $stmt_max_warranty = $pdo->prepare("SELECT MAX(s.warranty_days) as max_days FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE sp.service_order_id = ?");
            $stmt_max_warranty->execute([$id]);
            $max_days = $stmt_max_warranty->fetchColumn();

            if ($max_days > 0) {
                // Determine end date
                $warranty_end_date = date('Y-m-d', strtotime("+$max_days days"));
            }
        }

        $stmt = $pdo->prepare("UPDATE service_orders SET status = ?, total_fee = ?, warranty_end_date = ?, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$status, $total_fee, $warranty_end_date, $id]);

        // 2. Log History if Status Changed or Notes Added
        if ($status != $old_status || !empty($notes)) {
            $stmt = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$id, $old_status, $status, $notes, $user_id]);
        }

        $pdo->commit();

        $_SESSION['flash_message'] = "Status service berhasil diupdate!";
        $_SESSION['flash_type'] = "success";

        header("Location: view.php?id=$id");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}
?>
