<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM spareparts WHERE id = ?");
$stmt->execute([$id]);
$part = $stmt->fetch();

if (!$part) die("Data tidak ditemukan");
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header">
        <h2>Edit Sparepart</h2>
        <a href="index.php" class="btn-primary" style="background: #6b7280;">Kembali</a>
    </div>

    <form action="update.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $part['id']; ?>">
        
        <div class="form-group mb-3">
            <label>Nama Barang / Sparepart</label>
            <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($part['name']); ?>" required>
        </div>

        <div class="form-group mb-3">
            <label>Masa Garansi (Hari)</label>
            <input type="number" name="warranty_days" class="form-control" value="<?php echo $part['warranty_days']; ?>" placeholder="Biarkan 0 jika tidak ada">
        </div>

        <div class="grid-2">
            <div class="form-group mb-3">
                <label>Harga Beli (Modal)</label>
                <input type="number" name="buy_price" class="form-control" value="<?php echo $part['buy_price']; ?>" required>
            </div>
            <div class="form-group mb-3">
                <label>Harga Jual (Service)</label>
                <input type="number" name="sell_price" class="form-control" value="<?php echo $part['sell_price']; ?>" required>
            </div>
        </div>
        
        <div class="alert alert-info" style="font-size: 0.85rem; background: #eff6ff; color: #1e40af; border: 1px solid #bfdbfe;">
            <i class="fas fa-info-circle"></i> Info: Untuk mengubah stok, gunakan fitur "Adjust Stock" di halaman utama.
        </div>

        <button type="submit" class="btn-primary" style="width: 100%;">Update Data</button>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
