<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM spareparts WHERE id = ?");
$stmt->execute([$id]);
$part = $stmt->fetch();

if (!$part) die("Barang tidak ditemukan.");

$stmt_hist = $pdo->prepare("SELECT * FROM stock_history WHERE sparepart_id = ? ORDER BY created_at DESC");
$stmt_hist->execute([$id]);
$histories = $stmt_hist->fetchAll();
?>

<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header mb-3 d-flex justify-between align-center">
        <h2 style="margin: 0;">Riwayat Stok</h2>
        <a href="index.php" class="btn-primary" style="background: #6b7280; font-size: 0.9rem;">Kembali</a>
    </div>
    <p class="mb-4">Barang: <strong><?php echo $part['name']; ?></strong></p>

    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Tipe</th>
                    <th>Jumlah</th>
                    <th>Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($histories) > 0): ?>
                    <?php foreach ($histories as $log): ?>
                    <tr>
                        <td><?php echo date('d/m/Y H:i', strtotime($log['created_at'])); ?></td>
                        <td>
                            <?php 
                            if ($log['type'] == 'in') echo '<span class="badge" style="background: #10b981; color: white;">Masuk (+)</span>';
                            elseif ($log['type'] == 'out') echo '<span class="badge" style="background: #ef4444; color: white;">Keluar (-)</span>';
                            elseif ($log['type'] == 'adjustment') echo '<span class="badge" style="background: #f59e0b; color: white;">Opname</span>';
                            elseif ($log['type'] == 'return_defect') echo '<span class="badge" style="background: #ef4444; color: white;">Retur Garansi (Cacat)</span>';
                            else echo '<span class="badge" style="background: #6b7280; color: white;">' . $log['type'] . '</span>';
                            ?>
                        </td>
                        <td><strong><?php echo $log['qty']; ?></strong></td>
                        <td><?php echo $log['notes']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="4" class="text-center text-muted">Belum ada riwayat stok.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
