<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $stock = $_POST['stock'];
    $warranty_days = $_POST['warranty_days'] ?: 0;
    $buy_price = $_POST['buy_price'];
    $sell_price = $_POST['sell_price'];

    try {
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("INSERT INTO spareparts (name, stock, warranty_days, buy_price, sell_price) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $stock, $warranty_days, $buy_price, $sell_price]);
        $part_id = $pdo->lastInsertId();

        // Log Initial Stock
        if ($stock > 0) {
            $stmt = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'in', ?, 'Stok Awal')");
            $stmt->execute([$part_id, $stock]);
        }

        $pdo->commit();

        $_SESSION['flash_message'] = "Sparepart berhasil ditambahkan!";
        $_SESSION['flash_type'] = "success";
        header("Location: index.php");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}
?>
