<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $type = $_POST['type'];
    $qty = $_POST['qty'];
    $notes = $_POST['notes'];

    try {
        $pdo->beginTransaction();

        // Get current stock
        $stmt = $pdo->prepare("SELECT stock FROM spareparts WHERE id = ? FOR UPDATE");
        $stmt->execute([$id]);
        $current = $stmt->fetchColumn();

        $new_stock = $current;
        if ($type == 'in') {
            $new_stock += $qty;
        } elseif ($type == 'out') {
            $new_stock -= $qty;
        } elseif ($type == 'adjustment') {
            $new_stock = $qty; // Qty becomes the real physical stock
        }

        // Update Stock
        $stmt = $pdo->prepare("UPDATE spareparts SET stock = ? WHERE id = ?");
        $stmt->execute([$new_stock, $id]);

        // Log History
        $log_qty = ($type == 'adjustment') ? ($new_stock - $current) : $qty; // For adjustment, log the diff
        $stmt = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, ?, ?, ?)");
        $stmt->execute([$id, $type, $qty, $notes]);

        $pdo->commit();

        $_SESSION['flash_message'] = "Stok berhasil diupdate!";
        $_SESSION['flash_type'] = "success";
        header("Location: index.php");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}
?>
