<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

if ($_SESSION['role'] != 'admin') exit('Akses Ditolak');

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$id]);
$user = $stmt->fetch();

if (!$user) die("User tidak ditemukan");
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header d-flex justify-between align-center flex-wrap gap-4 mb-4">
        <h2 style="margin: 0;"><i class="fas fa-user-edit me-2"></i> Edit User</h2>
        <a href="index.php" class="btn-primary" style="background: var(--secondary-color); border-color: var(--secondary-color);">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="update.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
        
        <div class="form-group mb-3">
        <div class="form-group mb-3">
            <label class="form-label">Nama Lengkap</label>
            <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($user['name']); ?>" required>
        </div>
        <div class="form-group mb-3">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" required>
        </div>
        <div class="form-group mb-3">
            <label class="form-label">Password Baru (Kosongkan jika tidak ingin mengubah)</label>
            <input type="password" name="password" class="form-control" placeholder="***">
        </div>
        <div class="form-group mb-4">
            <label class="form-label">Role / Jabatan</label>
            <select name="role" class="form-control" required>
                <option value="teknisi" <?php echo $user['role'] == 'teknisi' ? 'selected' : ''; ?>>👨‍🔧 Teknisi</option>
                <option value="kasir" <?php echo $user['role'] == 'kasir' ? 'selected' : ''; ?>>👩‍💼 Kasir/Admin Depan</option>
                <option value="admin" <?php echo $user['role'] == 'admin' ? 'selected' : ''; ?>>👑 Administrator</option>
            </select>
        </div>
        <button type="submit" class="btn-primary" style="width: 100%; padding: 0.8rem; font-size: 1rem;">
            <i class="fas fa-save me-2"></i> Update User
        </button>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
