<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

// Check if Admin
if ($_SESSION['role'] != 'admin') {
    echo "<script>alert('Akses Ditolak!'); window.location='../../index.php';</script>";
    exit();
}

$stmt = $pdo->query("SELECT * FROM users ORDER BY role ASC, name ASC");
$users = $stmt->fetchAll();
?>

<div class="card">
    <div class="card-header d-flex justify-between align-center flex-wrap gap-4 mb-4">
        <h2 style="margin: 0;"><i class="fas fa-users-cog me-2"></i> Kelola User (Hak Akses)</h2>
        <a href="create.php" class="btn-primary">
            <i class="fas fa-plus"></i> Tambah User
        </a>
    </div>

    <div class="table-responsive">

    <table class="table">
        <thead>
            <tr>
                <th>Nama</th>
                <th>Username</th>
                <th>Role/Jabatan</th>
                <th>Dibuat</th>
                <th width="150">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
            <tr>
                <td><?php echo $user['name']; ?></td>
                <td><?php echo $user['username']; ?></td>
                <td>
                    <?php 
                    $role_bg = match($user['role']) {
                        'admin' => '#fee2e2; color: #991b1b', // Red
                        'teknisi' => '#e0f2fe; color: #075985', // Blue
                        'kasir' => '#dcfce7; color: #166534', // Green
                        default => '#f3f4f6'
                    };
                    echo "<span class='badge' style='background: $role_bg'>" . ucfirst($user['role']) . "</span>";
                    ?>
                </td>
                <td><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></td>
                <td>
                    <div class="d-flex justify-center gap-2">
                        <a href="edit.php?id=<?php echo $user['id']; ?>" class="btn-primary" style="background: var(--warning-color); border-color: var(--warning-color); padding: 0.4rem 0.6rem;" title="Edit"><i class="fas fa-edit"></i></a>
                        <?php if ($user['id'] != $_SESSION['user_id']): ?>
                        <a href="delete.php?id=<?php echo $user['id']; ?>" class="btn-primary" style="background: var(--danger-color); border-color: var(--danger-color); padding: 0.4rem 0.6rem;" onclick="return confirm('Hapus user ini secara permanen?')" title="Hapus"><i class="fas fa-trash"></i></a>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
