<?php
session_start();
require_once '../../config/database.php';

if ($_SESSION['role'] != 'admin') exit('Akses Ditolak');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = $_POST['role'];

    try {
        $stmt = $pdo->prepare("INSERT INTO users (name, username, password, role) VALUES (?, ?, ?, ?)");
        $stmt->execute([$name, $username, $password, $role]);

        $_SESSION['flash_message'] = "User berhasil ditambahkan!";
        $_SESSION['flash_type'] = "success";
        header("Location: index.php");
        exit();
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>
