<?php
session_start();
require_once 'config/database.php';

$ticket = $_GET['ticket'] ?? '';
$service = null;
$error = '';

if ($ticket) {
    // Search by Ticket Number
    $stmt = $pdo->prepare("SELECT so.*, c.name as customer_name FROM service_orders so JOIN customers c ON so.customer_id = c.id WHERE so.ticket_number = ?");
    $stmt->execute([$ticket]);
    $service = $stmt->fetch();

    if ($service) {
        // Get History
        $stmt_hist = $pdo->prepare("SELECT * FROM service_history WHERE service_order_id = ? ORDER BY created_at DESC");
        $stmt_hist->execute([$service['id']]);
        $histories = $stmt_hist->fetchAll();
    } else {
        $error = "Data tidak ditemukan. Mohon cek kembali Nomor Tiket Anda.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cek Status Service HP</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/servicehp/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: #f3f4f6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .tracking-container {
            width: 100%;
            max-width: 600px;
            padding: 2rem;
        }
        .tracking-box {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .timeline {
            position: relative;
            padding-left: 30px;
            margin-top: 20px;
        }
        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -34px;
            top: 5px;
            width: 10px;
            height: 10px;
            background: #2563eb;
            border-radius: 50%;
        }
        .timeline-item::after {
            content: '';
            position: absolute;
            left: -30px;
            top: 15px;
            width: 2px;
            height: 100%;
            background: #e5e7eb;
        }
        .timeline-item:last-child::after {
            display: none;
        }
    </style>
</head>
<body>

<div class="tracking-container">
    <div class="text-center mb-4">
        <h1 style="color: #2563eb; margin-bottom: 0.5rem;"><i class="fas fa-search-location"></i> Cek Status Service</h1>
        <p class="text-muted">Masukkan Nomor Tiket yang tertera di struk Anda.</p>
    </div>

    <div class="tracking-box">
        <form action="" method="GET" class="mb-4">
            <div style="display: flex; gap: 10px;">
                <input type="text" name="ticket" class="form-control" placeholder="Contoh: SRV-202310-001" value="<?php echo htmlspecialchars($ticket); ?>" required>
                <button type="submit" class="btn-primary" style="width: auto;">Cek</button>
            </div>
        </form>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if ($service): ?>
            <div style="border-bottom: 1px solid #eee; padding-bottom: 1rem; margin-bottom: 1rem;">
                <h3 style="margin: 0; color: #1e40af;"><?php echo $service['device_name']; ?></h3>
                <span class="badge" style="background: #eff6ff; color: #1e40af; font-size: 0.9rem; margin-top: 5px; display: inline-block;">
                    Status: <?php echo $service['status']; ?>
                </span>
                <p class="mt-2 text-muted">Milik: <?php echo $service['customer_name']; ?></p>
            </div>

            <div style="background: #f9fafb; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <p style="margin: 0; display: flex; justify-content: space-between;">
                    <span>Estimasi Biaya:</span> 
                    <strong>Rp <?php echo number_format($service['total_fee'] > 0 ? $service['total_fee'] : $service['cost_estimation'], 0, ',', '.'); ?></strong>
                </p>
                <?php if ($service['warranty_end_date']): ?>
                <p style="margin: 10px 0 0 0; display: flex; justify-content: space-between; border-top: 1px solid #e5e7eb; padding-top: 10px;">
                    <span>Status Garansi:</span>
                    <?php 
                        $end_date = strtotime($service['warranty_end_date']);
                        $is_expired = time() > $end_date;
                        $color = $is_expired ? 'red' : 'green';
                        echo "<strong style='color: $color;'>" . ($is_expired ? "Habis (Expired)" : "Aktif s.d " . date('d/m/Y', $end_date)) . "</strong>";
                    ?>
                </p>
                <?php endif; ?>
            </div>

            <h4>Riwayat Pengerjaan</h4>
            <div class="timeline">
                <?php foreach ($histories as $hist): ?>
                <div class="timeline-item">
                    <strong><?php echo $hist['status_new']; ?></strong>
                    <div class="text-muted small"><?php echo date('d M Y, H:i', strtotime($hist['created_at'])); ?></div>
                    <div><?php echo $hist['notes']; ?></div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="text-center mt-4">
                <a href="auth/login.php" style="text-decoration: none; font-size: 0.9rem; color: #9ca3af;">Login Staff</a>
            </div>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
